//Exemple d'utilisation de Display.pas et GestionDX.pas
//Auteur : Clment Gatin UB42
// (C) 2002 Clment Gatin


unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, Display, GestionDX;

type
  TForm1 = class(TForm)
    procedure FormActivate(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure FormDeactivate(Sender: TObject);
    procedure FormKeyDown(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
  private
    { Dclarations prives }
    FActive: Boolean;
    Boules: array[1..2] of TNepSurface;
    X,Y:integer;
    VectX, VectY:Single;
    procedure FormOnIdle(Sender:TObject; var Done: Boolean);

  public
    { Dclarations publiques }
  end;

var
  Form1: TForm1;

implementation

{$R *.dfm}

procedure TForm1.FormActivate(Sender: TObject);
begin
 FActive := True;

end;

procedure TForm1.FormCreate(Sender: TObject);
var
AppPath, s : String;
n: integer;
begin
  Application.OnIdle := FormOnIdle;
  //Dfinit la variable AppPath qui contient le chemin de l'excutable en cours.
  AppPath := '';
  S := ParamStr(0);
  while Pos('\',S) <> 0 do
  begin
    AppPath := AppPath + Copy(S,0,Pos('\',S));
    S := Copy(S,Pos('\',S) + 1, Length(S) - Pos('\',S));
  end;

  //Init DirectX
  InitDirectDraw(Handle,800,600,16);
  For n := 1 to 2 do begin
    Boules[n] := GetNewSurface;
    Boules[n].LoadFromBMPFile(PChar(AppPath + 'Boule' + IntToStr(n) +  '.bmp'));
  end;
  VectX := 15;
  VectY := 20;
  X := 1;
  Y := 1;
  Boules[2].SetTransColorXY(0,0);

end;

procedure TForm1.FormOnIdle(Sender:TObject; var Done: Boolean);
begin
  //Code de la boucle de jeu
  If FActive then begin
    Boules[1].BlitXY(0,0,0,0,800,600,False);

    X := X + Trunc(VectX);
    Y := Y + Trunc(VectY);
    if VectY < 0 then VectY := VectY + 0.2;
    if VectY > 0 then VectY := VectY + 0.1;
    VectX := VectX * 0.997;


    If X > (800 - 50) then begin
      X := 800 - 50;
      VectX := - VectX;
    end;
    If Y > (600 - 50) then begin
      Y := 600 - 50;
      VectY := - VectY;
    end;
    If X < 0 then begin
      X := 0;
      VectX := - VectX;
    end;
    If Y < 0 then begin
      Y := 0;
      VectY := - VectY;
    end;
    Boules[2].BlitXY(X,Y,0,0,50,50,True);

    Flip;
  end;
  Done := False;

end;


procedure TForm1.FormDeactivate(Sender: TObject);
begin
  FActive := False;

end;

procedure TForm1.FormKeyDown(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
  Application.Terminate;

end;

procedure TForm1.FormClose(Sender: TObject; var Action: TCloseAction);
begin
  ExitDirectDraw;
  ExitDirectX;
end;

end.
 